/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import com.rsi.javab.ReflObject;
import com.rsi.javab.ReflUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;

public class ReflPromotion {
    private static boolean DEBUG_CTOR_PROM = false;

    public static Vector eliminatePromotableCtors(Vector vCtors) {
        int i;
        Constructor m1 = null;
        Constructor m2 = null;
        int nMatches = vCtors.size();
        boolean[] bRemove = new boolean[nMatches];
        for (i = 0; i < nMatches; ++i) {
            bRemove[i] = false;
        }
        for (i = 0; i < nMatches; ++i) {
            m1 = (Constructor)vCtors.elementAt(i);
            for (int j = 0; j < nMatches; ++j) {
                Constructor superMeth;
                if (j == i || (superMeth = ReflPromotion.whichCtorIsSuperclass(m1, m2 = (Constructor)vCtors.elementAt(j))) != null && superMeth != m2 || !ReflPromotion.mayCtorBePromotedToCtor(m1, m2)) continue;
                bRemove[j] = true;
            }
        }
        for (i = nMatches - 1; i >= 0; --i) {
            if (!bRemove[i]) continue;
            vCtors.remove(i);
        }
        return vCtors;
    }

    public static boolean doesCtorHaveExactSig(Constructor m, String sSig) {
        boolean bRetVal = false;
        Class[] inClassArr = ReflUtil.sigToClassArray(sSig);
        Class[] methodArr = m.getParameterTypes();
        bRetVal = ReflPromotion.areClassArraysEqual(inClassArr, methodArr);
        return bRetVal;
    }

    private static Constructor whichCtorIsSuperclass(Constructor m1, Constructor m2) {
        Class cl1 = m1.getDeclaringClass();
        Class cl2 = m2.getDeclaringClass();
        Constructor mRetVal = null;
        if (cl1 != cl2) {
            if (cl1.isAssignableFrom(cl2)) {
                mRetVal = m1;
            } else if (cl2.isAssignableFrom(cl1)) {
                mRetVal = m2;
            }
        }
        return mRetVal;
    }

    private static boolean mayCtorBePromotedToCtor(Constructor m1, Constructor m2) {
        boolean bRetVal;
        block7: {
            Class<?>[] methodArr2;
            Class<?>[] methodArr1;
            block6: {
                bRetVal = false;
                methodArr1 = m1.getParameterTypes();
                methodArr2 = m2.getParameterTypes();
                if (DEBUG_CTOR_PROM) {
                    System.out.println("   >mayCtorBePromoted");
                    if (methodArr1 != null) {
                        System.out.println("    mayCtorBePromoted methodArr1 size=" + methodArr1.length);
                    }
                    if (methodArr2 != null) {
                        System.out.println("    mayCtorBePromoted methodArr2 size=" + methodArr2.length);
                    }
                }
                if (methodArr1 != null && methodArr2 != null) break block6;
                if (methodArr1 != null || methodArr2 != null) break block7;
                bRetVal = true;
                break block7;
            }
            if (methodArr1.length == methodArr2.length) {
                bRetVal = true;
                for (int i = 0; i < methodArr1.length; ++i) {
                    if (ReflPromotion.mayClassBePromoted(methodArr1[i], methodArr2[i])) continue;
                    bRetVal = false;
                    break;
                }
            }
        }
        if (DEBUG_CTOR_PROM) {
            System.out.println("   <mayCtor " + String.valueOf(m1) + " mayBePromotedToCtor " + String.valueOf(m2) + " result:" + bRetVal + "---------");
        }
        return bRetVal;
    }

    private static boolean areCtorsOfSameClass(Constructor m1, Constructor m2) {
        return m1.getDeclaringClass() == m2.getDeclaringClass();
    }

    public static boolean maySigBePromotedToCtor(String sSig, Constructor ctor, int iOpts) {
        boolean bRetVal = false;
        Class[] inClassArr = ReflUtil.sigToClassArray(sSig);
        Class[] ctorArr = ctor.getParameterTypes();
        if (DEBUG_CTOR_PROM) {
            System.out.println("   maySigBePromotedToCtor sSig=" + sSig);
            if (inClassArr != null) {
                System.out.println("   maySigBePromotedToCtor classArr size=" + inClassArr.length);
            }
            if (ctorArr != null) {
                System.out.println("   maySigBePromotedToCtor ctorArr size=" + ctorArr.length);
            }
            System.out.println("   maySigBePromotedToCtor check params first...");
        }
        bRetVal = ReflPromotion.mayClassArrayBePromoted(inClassArr, ctorArr);
        if (DEBUG_CTOR_PROM) {
            System.out.println("   maySigBePromotedToCtor bRetVal=" + bRetVal);
        }
        return bRetVal;
    }

    public static Vector eliminatePromotableMethods(Vector vMethods) {
        int i;
        Method m1 = null;
        Method m2 = null;
        int nMatches = vMethods.size();
        boolean[] bRemove = new boolean[nMatches];
        for (i = 0; i < nMatches; ++i) {
            bRemove[i] = false;
        }
        for (i = 0; i < nMatches; ++i) {
            m1 = (Method)vMethods.elementAt(i);
            for (int j = 0; j < nMatches; ++j) {
                Method superMeth;
                if (j == i || (superMeth = ReflPromotion.whichMethodIsSuperclass(m1, m2 = (Method)vMethods.elementAt(j))) != null && superMeth != m2 || !ReflPromotion.mayMethodBePromotedToMethod(m1, m2) || !m2.getReturnType().isAssignableFrom(m1.getReturnType())) continue;
                bRemove[j] = true;
            }
        }
        for (i = nMatches - 1; i >= 0; --i) {
            if (!bRemove[i]) continue;
            vMethods.remove(i);
        }
        return vMethods;
    }

    public static boolean doesMethodHaveExactSig(Method m, String sSig) {
        Class[] methodArr;
        boolean bRetVal = false;
        Class[] inClassArr = ReflUtil.sigToClassArray(sSig);
        bRetVal = ReflPromotion.areClassArraysEqual(inClassArr, methodArr = m.getParameterTypes());
        if (bRetVal) {
            Class classRet = ReflUtil.sigToReturnType(sSig);
            Class<?> methodRet = m.getReturnType();
            bRetVal = ReflPromotion.areClassesEqual(classRet, methodRet);
        }
        return bRetVal;
    }

    public static boolean maySigBePromotedToMethod(String sSig, Method m, int iOpts) {
        boolean bRetVal = false;
        Class[] inClassArr = ReflUtil.sigToClassArray(sSig);
        Class[] methodArr = m.getParameterTypes();
        bRetVal = ReflPromotion.mayClassArrayBePromoted(inClassArr, methodArr);
        if (ReflObject.checkReturnType(iOpts) && bRetVal) {
            Class classRet = ReflUtil.sigToReturnType(sSig);
            if (classRet == null) {
                bRetVal = false;
            } else {
                Class<?> methodRet = m.getReturnType();
                bRetVal = ReflPromotion.mayClassBePromoted(classRet, methodRet);
            }
        }
        return bRetVal;
    }

    private static boolean mayPrimitiveBePromoted(String sType1, String sType2) {
        boolean retVal = false;
        switch (sType2.charAt(0)) {
            case 'b': {
                if (sType2.charAt(1) == 'o') {
                    if (!sType1.equals("boolean") && !sType1.equals("byte") && !sType1.equals("short") && !sType1.equals("char") && !sType1.equals("int") && !sType1.equals("long")) break;
                    retVal = true;
                    break;
                }
                if (sType2.charAt(1) != 'y' || !sType1.equals("byte")) break;
                retVal = true;
                break;
            }
            case 's': {
                if (!sType1.equals("byte") && !sType1.equals("char") && !sType1.equals("short")) break;
                retVal = true;
                break;
            }
            case 'c': {
                if (!sType1.equals("byte") && !sType1.equals("char")) break;
                retVal = true;
                break;
            }
            case 'i': {
                if (!sType1.equals("byte") && !sType1.equals("short") && !sType1.equals("char") && !sType1.equals("int")) break;
                retVal = true;
                break;
            }
            case 'l': {
                if (!sType1.equals("byte") && !sType1.equals("short") && !sType1.equals("char") && !sType1.equals("int") && !sType1.equals("long")) break;
                retVal = true;
                break;
            }
            case 'f': {
                if (!sType1.equals("byte") && !sType1.equals("short") && !sType1.equals("char") && !sType1.equals("int") && !sType1.equals("long") && !sType1.equals("float")) break;
                retVal = true;
                break;
            }
            case 'd': {
                if (!sType1.equals("byte") && !sType1.equals("short") && !sType1.equals("char") && !sType1.equals("int") && !sType1.equals("long") && !sType1.equals("float") && !sType1.equals("double")) break;
                retVal = true;
                break;
            }
            case 'v': {
                if (!sType1.equals("void")) break;
                retVal = true;
                break;
            }
            default: {
                System.out.println("ERR mayPrimitiveBePromoted type " + sType2 + " not found");
            }
        }
        if (DEBUG_CTOR_PROM) {
            System.out.println("       =mayPrimitiveBePromoted: " + sType1 + (retVal ? " may" : " may not") + " be promoted to " + sType2);
        }
        return retVal;
    }

    public static boolean mayClassBePromoted(Class class1, Class class2) {
        boolean retVal = false;
        if (ReflPromotion.areClassesEqual(class1, class2)) {
            retVal = true;
        } else if (class1 == null) {
            if (!class2.isPrimitive()) {
                retVal = true;
            }
        } else if (class1.isPrimitive() && class2.isPrimitive()) {
            String sType1 = class1.toString();
            String sType2 = class2.toString();
            retVal = ReflPromotion.mayPrimitiveBePromoted(sType1, sType2);
        } else {
            retVal = class1.isArray() && class2.isArray() ? ReflPromotion.mayClassBePromoted(class1.getComponentType(), class2.getComponentType()) : class2.isAssignableFrom(class1);
        }
        if (DEBUG_CTOR_PROM) {
            System.out.println("       =mayClassBePromoted: " + (class1 != null ? class1.toString() : "<null>") + (retVal ? " may" : " may not") + " be promoted to " + class2.toString());
        }
        return retVal;
    }

    private static boolean mayMethodBePromotedToMethod(Method m1, Method m2) {
        boolean bRetVal;
        block3: {
            Class<?>[] methodArr2;
            Class<?>[] methodArr1;
            block2: {
                bRetVal = false;
                methodArr1 = m1.getParameterTypes();
                methodArr2 = m2.getParameterTypes();
                if (methodArr1 != null && methodArr2 != null) break block2;
                if (methodArr1 != null || methodArr2 != null) break block3;
                bRetVal = true;
                break block3;
            }
            if (methodArr1.length == methodArr2.length) {
                bRetVal = true;
                for (int i = 0; i < methodArr1.length; ++i) {
                    if (ReflPromotion.mayClassBePromoted(methodArr1[i], methodArr2[i])) continue;
                    bRetVal = false;
                    break;
                }
            }
        }
        return bRetVal;
    }

    private static boolean doMethodsHaveExactSignatures(Method m1, Method m2) {
        boolean bRetVal;
        block3: {
            Class<?>[] methodArr2;
            Class<?>[] methodArr1;
            block2: {
                bRetVal = false;
                methodArr1 = m1.getParameterTypes();
                methodArr2 = m2.getParameterTypes();
                if (methodArr1 != null && methodArr2 != null) break block2;
                if (methodArr1 != null || methodArr2 != null) break block3;
                bRetVal = true;
                break block3;
            }
            if (methodArr1.length == methodArr2.length) {
                bRetVal = true;
                for (int i = 0; i < methodArr1.length; ++i) {
                    if (ReflPromotion.areClassesEqual(methodArr1[i], methodArr2[i])) continue;
                    bRetVal = false;
                    break;
                }
            }
        }
        return bRetVal;
    }

    private static boolean areMethodsOfSameClass(Method m1, Method m2) {
        return m1.getDeclaringClass() == m2.getDeclaringClass();
    }

    private static Method whichMethodIsSuperclass(Method m1, Method m2) {
        Class<?> cl1 = m1.getDeclaringClass();
        Class<?> cl2 = m2.getDeclaringClass();
        Method mRetVal = null;
        if (cl1 != cl2) {
            if (cl1.isAssignableFrom(cl2)) {
                mRetVal = m1;
            } else if (cl2.isAssignableFrom(cl1)) {
                mRetVal = m2;
            }
        }
        return mRetVal;
    }

    private static boolean areClassesEqual(Class class1, Class class2) {
        boolean retVal = false;
        if (class1 == class2) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean mayClassArrayBePromoted(Class[] classArr1, Class[] classArr2) {
        boolean bRetVal;
        block5: {
            block4: {
                bRetVal = false;
                if (classArr1 != null && classArr2 != null) break block4;
                if (classArr1 != null || classArr2 != null) break block5;
                bRetVal = true;
                break block5;
            }
            if (classArr1.length == 0 && classArr2.length == 0) {
                bRetVal = true;
            } else if (classArr1.length == classArr2.length) {
                bRetVal = true;
                for (int i = 0; i < classArr1.length; ++i) {
                    if (ReflPromotion.mayClassBePromoted(classArr1[i], classArr2[i])) continue;
                    bRetVal = false;
                    break;
                }
            }
        }
        return bRetVal;
    }

    private static boolean areClassArraysEqual(Class[] classArr1, Class[] classArr2) {
        boolean bRetVal = false;
        if (classArr1 == null || classArr2 == null) {
            bRetVal = classArr1 == null && classArr2 == null;
        } else if (classArr1.length == 0 && classArr2.length == 0) {
            bRetVal = true;
        } else if (classArr1.length != classArr2.length) {
            bRetVal = false;
        } else {
            for (int i = 0; i < classArr1.length; ++i) {
                if (!ReflPromotion.areClassesEqual(classArr1[i], classArr2[i])) {
                    bRetVal = false;
                    break;
                }
                bRetVal = true;
            }
        }
        return bRetVal;
    }

    public static boolean mayTypeBePromotedToField(String sType, Field f, int iOpts) {
        boolean bRetVal = false;
        Class[] inClassArr = ReflUtil.sigToClassArray(sType);
        Class<?> fieldType = f.getType();
        bRetVal = ReflPromotion.mayClassBePromoted(inClassArr[0], fieldType);
        return bRetVal;
    }
}

