; Copyright (c)  NV5 Geospatial Solutions, Inc. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;+
; CLASS_NAME:
;    YAML_Value
;
; PURPOSE:
;    The YAML_Value class is used to create a YAML value,
;    containing a string VALUE and an optional TAG.
;
; CATEGORY:
;    Datatypes
;
;-

;---------------------------------------------------------------------------
function YAML_Value::Init, value, ANCHOR=anchor, TAG=tag
  compile_opt IDL2, HIDDEN
  if (n_params() gt 0) then begin
    self.YAML_Value::SetProperty, ANCHOR=anchor, TAG=tag, VALUE=value
  endif else begin
    self.YAML_Value::SetProperty, ANCHOR=anchor, TAG=tag
  endelse
  return, 1
end

;---------------------------------------------------------------------------
pro YAML_Value::SetProperty, ANCHOR=anchor, TAG=tag, VALUE=value
  compile_opt IDL2, HIDDEN
  if (isa(value) || isa(value,/null)) then v = yaml_serialize(value)
  self.YAML_Node::SetProperty, ANCHOR=anchor, TAG=tag, VALUE=v
end

;---------------------------------------------------------------------------
pro YAML_Value__DEFINE
  compile_opt IDL2, HIDDEN
  void = {YAML_Value, $
    inherits YAML_Node, $
    inherits IDL_Object}
end
