
# Korn and Bash shell commands to define IDL environment variables for the 
# connectivity bridges.
#
# These scripts can be used by IDL users who use ksh or bash as their 
# interactive shell to define the environment variables required 
# by IDL connectivity bridges using the following command:
#
# Korn shell users should run bridge_setup.ksh from their .profile file,
# using the full path the the IDL directory as follows:
#    . /usr/local/nv5/idl92/bin/bridge_setup.ksh
# Bash shell users should source bridge_setup.bash from their .bashrc files,
# using the full path to the IDL directory as follows:
#    . /usr/local/nv5/idl92/bin/bridge_setup.bash
#

ENVI_IDL_DIR=/usr/local/nv5
IDL_DIR=/usr/local/nv5/idl92
export ENVI_IDL_DIR IDL_DIR

UNAME=`uname`

case $UNAME in
	"Linux")
           ARCH=".x86_64"
           BIN_DIR="$IDL_DIR/bin/bin.linux$ARCH"
           if [ "$LD_LIBRARY_PATH" = "" ]; then
               LD_LIBRARY_PATH="$BIN_DIR"
           else
               LD_LIBRARY_PATH="$BIN_DIR":"$LD_LIBRARY_PATH"
           fi
           export LD_LIBRARY_PATH
        ;;

	"Darwin")
           ARCH=".x86_64"
 	   BIN_DIR="$IDL_DIR/bin/bin.darwin$ARCH"
           if [ "$DYLD_LIBRARY_PATH" = "" ]; then
               DYLD_LIBRARY_PATH="$BIN_DIR"
           else
               DYLD_LIBRARY_PATH="$BIN_DIR":"$DYLD_LIBRARY_PATH"
           fi
           export DYLD_LIBRARY_PATH
        ;;

        *)
        ;;
    
esac

PATH="$PATH:$BIN_DIR"
export PATH

if [ $CLASSPATH ];  then
    CLASSPATH="$CLASSPATH":.:"$IDL_DIR/resource/bridges/export/java/javaidlb.jar"
else
    CLASSPATH=".:$IDL_DIR/resource/bridges/export/java/javaidlb.jar"
fi
export CLASSPATH


