/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Date;

public class JIDLEvent {
    private long m_hwnd;
    private int m_msg;
    private int m_wp;
    private int m_lp;
    protected static final int WM_MOUSEMOVE = 512;
    protected static final int WM_LBUTTONDOWN = 513;
    protected static final int WM_LBUTTONUP = 514;
    protected static final int WM_LBUTTONDBLCLK = 515;
    protected static final int WM_RBUTTONDOWN = 516;
    protected static final int WM_RBUTTONUP = 517;
    protected static final int WM_RBUTTONDBLCLK = 518;
    protected static final int WM_MBUTTONDOWN = 519;
    protected static final int WM_MBUTTONUP = 520;
    protected static final int WM_MBUTTONDBLCLK = 521;
    protected static final int WM_NCMOUSEMOVE = 160;
    protected static final int WM_GETMINMAXINFO = 36;
    protected static final int WM_SIZE = 5;
    protected static final int WM_ACTIVATE = 6;
    protected static final int WM_QUERYNEWPALETTE = 783;
    protected static final int WM_PALETTECHANGED = 785;
    protected static final int WM_COMMAND = 273;
    protected static final int WM_KEYDOWN = 256;
    protected static final int WM_KEYUP = 257;
    protected static final int WM_CHAR = 258;
    protected static final int WM_SETCURSOR = 32;
    protected static final int WM_DESTROY = 2;
    protected static final int WM_ERASEBKGND = 20;
    protected static final int WM_WINDOWPOSCHANGED = 71;
    protected static final int MK_LBUTTON = 1;
    protected static final int MK_RBUTTON = 2;
    protected static final int MK_SHIFT = 4;
    protected static final int MK_CONTROL = 8;
    protected static final int MK_MBUTTON = 16;
    protected static final int MK_XBUTTON1 = 32;
    protected static final int MK_XBUTTON2 = 64;

    public JIDLEvent(long hwnd, int msg, int wp, int lp) {
        this.m_hwnd = hwnd;
        this.m_msg = msg;
        this.m_wp = wp;
        this.m_lp = lp;
    }

    public long getHwnd() {
        return this.m_hwnd;
    }

    public int getMsg() {
        return this.m_msg;
    }

    public int getWp() {
        return this.m_wp;
    }

    public int getLp() {
        return this.m_lp;
    }

    protected static boolean isMouseMotionEvent(int msg) {
        boolean bIsMouse = false;
        if (msg == 512 || msg == 160) {
            bIsMouse = true;
        }
        return bIsMouse;
    }

    protected static boolean isKeyEvent(int msg) {
        boolean bIsKey = false;
        if (msg == 256 || msg == 257) {
            bIsKey = true;
        }
        return bIsKey;
    }

    protected static boolean isMouseEvent(int msg) {
        boolean bIsMouse = false;
        if (msg >= 513 && msg <= 521) {
            bIsMouse = true;
        }
        return bIsMouse;
    }

    protected static MouseEvent createMouseEvent(Component src, int msg, int lp, int wp) {
        MouseEvent mouseEv = null;
        int x = lp & 0xFFFF;
        int y = (lp & 0xFFFF0000) >>> 16;
        int modifiers = 0;
        int mouseID = 0;
        long when = new Date().getTime();
        if ((wp & 8) == 8) {
            modifiers |= 2;
        }
        if ((wp & 4) == 4) {
            modifiers |= 1;
        }
        boolean bButtonDown = false;
        if ((wp & 1) == 1) {
            modifiers |= 0x10;
            bButtonDown = true;
        }
        if ((wp & 0x10) == 16) {
            modifiers |= 8;
            bButtonDown = true;
        }
        if ((wp & 2) == 2) {
            modifiers |= 4;
            bButtonDown = true;
        }
        switch (msg) {
            case 512: {
                if (bButtonDown) {
                    mouseID = 506;
                    break;
                }
                mouseID = 503;
                break;
            }
            case 513: {
                modifiers |= 0x10;
                mouseID = 501;
                break;
            }
            case 514: {
                modifiers |= 0x10;
                mouseID = 502;
                break;
            }
            case 519: {
                modifiers |= 8;
                mouseID = 501;
                break;
            }
            case 520: {
                modifiers |= 8;
                mouseID = 502;
                break;
            }
            case 516: {
                modifiers |= 4;
                mouseID = 501;
                break;
            }
            case 517: {
                modifiers |= 4;
                mouseID = 502;
                break;
            }
            default: {
                System.out.println("ERR* event not recognized");
            }
        }
        if (mouseID != 0) {
            mouseEv = new MouseEvent(src, mouseID, when, modifiers, x, y, 1, false);
        }
        return mouseEv;
    }

    protected static KeyEvent createKeyEvent(Component src, int msg, int lp, int wp, boolean bShift, boolean bControl, boolean bAlt, boolean bMeta) {
        int modifiers = 0;
        int keyID = 0;
        KeyEvent keyEv = null;
        long when = new Date().getTime();
        char cKeyChar = (char)wp;
        int iKeyCode = wp;
        switch (msg) {
            case 256: {
                keyID = 401;
                break;
            }
            case 257: {
                keyID = 402;
                break;
            }
            default: {
                System.out.println("ERR* event not recognized");
            }
        }
        if (bShift) {
            modifiers |= 1;
            cKeyChar = Character.toUpperCase(cKeyChar);
        } else {
            cKeyChar = Character.toLowerCase(cKeyChar);
        }
        if (bControl) {
            modifiers |= 2;
        }
        if (bAlt) {
            modifiers |= 8;
        }
        if (bMeta) {
            modifiers |= 4;
        }
        if (keyID != 0) {
            keyEv = new KeyEvent(src, keyID, when, modifiers, iKeyCode, cKeyChar);
        }
        return keyEv;
    }

    protected static String getModifierDebugInfo(InputEvent e) {
        int mods = e.getModifiers();
        String s = "mods=0x" + Integer.toHexString(mods) + " (" + ((mods & 0x10) == 16 ? "BUTTON1_MASK " : "") + ((mods & 8) == 8 ? "BUTTON2_MASK " : "") + ((mods & 4) == 4 ? "BUTTON3_MASK " : "") + ((mods & 0x20) == 32 ? "ALT_GRAPH_MASK " : "") + ((mods & 8) == 8 ? "ALT_MASK " : "") + ((mods & 2) == 2 ? "CTRL_MASK " : "") + ((mods & 4) == 4 ? "META_MASK " : "") + ((mods & 1) == 1 ? "SHIFT_MASK " : "") + ")";
        return s;
    }

    public String toString() {
        return "JIDLEvent [hwnd=" + this.getHwnd() + " msg=" + this.getMsg() + " wparam=0x" + Integer.toHexString(this.getWp()) + " lparam=0x" + Integer.toHexString(this.getLp()) + "]";
    }

    public static void printKeyInfo(String sPrefix, KeyEvent e) {
        System.out.println(sPrefix + " KeyChar:" + e.getKeyChar() + " KeyCode:" + e.getKeyCode() + " " + JIDLEvent.getModifierDebugInfo(e));
    }

    public static void printMouseInfo(String sPrefix, MouseEvent e) {
        System.out.println(sPrefix + " (" + e.getX() + "," + e.getY() + ") " + JIDLEvent.getModifierDebugInfo(e));
    }
}

