/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

public class IDLJavaVersion {
    private String m_sBridgeVersion;
    private String m_sJNIVersion;
    private String m_sBuildDate;
    private String m_sPlatform;
    private String m_sSharedLibVersion;

    public IDLJavaVersion(String sJNIVersion, String sBuildDate, String sPlatform, String sSharedLibVersion, String sIDLVersion) {
        this.m_sBridgeVersion = sIDLVersion;
        String[] values = this.m_sBridgeVersion.split("\\.");
        if (values.length >= 3 && values[2].equals("0")) {
            this.m_sBridgeVersion = values[0] + "." + values[1];
        }
        this.m_sJNIVersion = sJNIVersion;
        this.m_sBuildDate = new String(sBuildDate);
        this.m_sPlatform = sPlatform;
        this.m_sSharedLibVersion = sSharedLibVersion;
    }

    public String getBridgeVersion() {
        return this.m_sBridgeVersion;
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getBuildDate() {
        return this.m_sBuildDate;
    }

    public String getJNIVersion() {
        return this.m_sJNIVersion;
    }

    public String getPlatform() {
        return this.m_sPlatform;
    }

    public String getSharedLibraryVersion() {
        return this.m_sSharedLibVersion;
    }

    public String getJARFileVersion() {
        return "1.0.0.0";
    }

    public static void main(String[] args) {
        IDLJavaVersion o = new IDLJavaVersion("0x10001", "today", "Windows", "1.0", "1.0.0");
        System.out.println("Bridge Version: " + o.getBridgeVersion());
        System.out.println("Java Version  : " + o.getJavaVersion());
        System.out.println("JNI Version   : " + o.getJNIVersion());
        System.out.println("Build date    : " + o.getBuildDate());
        System.out.println("Platform      : " + o.getPlatform());
        System.out.println("Build date    : " + o.getSharedLibraryVersion());
    }
}

