; Copyright (c)  NV5 Geospatial Solutions, Inc. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;----------------------------------------------------------------------------
; :Description:
;    The YAML_SERIALIZE function takes an IDL variable or data structure and
;    serializes it to a YAML string.
;
; :Returns:
;    The result will be a scalar string.
;   
; :Params:
;    Data:
;      The IDL variable or data structure to be serialized.
;
; :Author:
;   CT, March 2023.
;-
function YAML_Serialize, data

  compile_opt idl2, hidden
  ON_ERROR, 2
  
  CATCH, iErr
  if (iErr ne 0) then begin
    CATCH, /CANCEL
    msg = (!ERROR_STATE.MSG).Replace('YAML_SERIALIZE_INTERNAL: ', '')
    message, msg
  endif

  result = yaml_serialize_internal(data)

  if (isa(data, 'YAML_Multidoc') || isa(data, 'YAML_Stream_Map') || $
    isa(data, 'YAML_Stream_Sequence')) then begin
    comments = data.comments
    foreach c, comments, i do begin
      if (c && ~c.startsWith('#') && ~c.startsWith('%YAML')) then comments[i] = '# ' + c
    endforeach
    comments = comments.join(`\n`)
    if (strlen(comments) gt 0) then begin
      result = comments + `\n` + result
    endif
  endif
  return, result
end

