/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.symbol.shape;

import com.rsi.pdf.map.symbol.shape.AbstractShape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class Star
extends AbstractShape {
    @Override
    public void drawShape(PDPageContentStream contentStream, float screenX, float screenY, float size, float rotation) throws IOException {
        Path2D.Float star = new Path2D.Float();
        double starAngle = 1.2566370614359172;
        float nextPointIndex = 2.0f;
        star.moveTo(screenX + size / 2.0f, screenY);
        for (int pointCounter = 1; pointCounter < 5; ++pointCounter) {
            star.lineTo((double)screenX + (double)(0.5f * size) * Math.cos((double)nextPointIndex * starAngle), (double)screenY + (double)(0.5f * size) * Math.sin((double)nextPointIndex * starAngle));
            nextPointIndex = (nextPointIndex + 2.0f) % 5.0f;
        }
        star.closePath();
        Area area = new Area(star);
        AffineTransform xform = new AffineTransform();
        xform.setToRotation(Math.toRadians(234.0f - rotation), screenX, screenY);
        this.drawPathIterator(area.getPathIterator(xform), contentStream);
    }

    @Override
    public boolean hasFill() {
        return true;
    }

    @Override
    public boolean hasOutline() {
        return true;
    }

    @Override
    public String getName() {
        return "Star";
    }
}

