/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.datasource;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.datasource.IRasterDataSource;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class RasterFileDataSource
implements IRasterDataSource {
    private PDXObjectImage ximage = null;
    private Envelope mapExtent = null;

    public RasterFileDataSource(PdfMap pdfMap, String filename, Envelope mapExtent) throws IOException {
        if (pdfMap == null || filename == null || mapExtent == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : null argument(s)");
        }
        BufferedImage bufferedImage = ImageIO.read(new File(filename));
        this.ximage = new PDPixelMap(pdfMap.getDocument(), bufferedImage);
        this.mapExtent = mapExtent;
    }

    @Override
    public PDXObjectImage getImage() {
        return this.ximage;
    }

    @Override
    public Envelope getImageExtent() {
        return this.mapExtent;
    }
}

